-- DATA MANIPULATION LANGUAGE (DML): Veritabannda Data Definition Language (DDL) ile oluturduumuz yaplarda, 
-- rnein stunlar zerinden tablolarda, yeni kayt ekleme, mevcut bir kayd gncelleme ve silme vb. veri ilemleri iin kullanlr.

-- SQL veri tipleri ve veri rnekleri:
-- Saysal veri tipleri (Tam say):
-- 1 byte = 8 bit

-- bigint: 123
-- 64 bit byklnde -9,223,372,036,854,775,808 ile 9,223,372,036,854,775,807 arasnda deer tutabilen tam say veri tipidir.

-- int: -321
-- 32 bit byklnde -2,147,483,648 ile 2,147,483,647 arasnda deer tutabilen tam say veri tipidir.

-- smallint: -98
-- 16 bit byklnde -32,768 ile 32,767 arasnda deer tutabilen tam say veri tipidir.

-- tinyint: 89
-- 8 bit byklnde 0 ile 255 arasnda deer tutabilen tam say veri tipidir.

-- bit: 1
-- 8 bit byklnde 0 ile 1 arasnda deer tutabilen tam say veri tipidir.

-- Saysal veri tipleri (Ondalk say):
-- float: 57.35
-- -1.79E+308 ile 1.79E+308 arasnda deer tutabilen ondalk say veri tipidir.

-- decimal(9, 2): -12345.6
-- -10^38 + 1 ile 10^38 - 1 arasnda deer tutabilen ondalk say veri tipidir.
-- Bu rnekte 9 ondalk iareti dahil toplam maksimum hane saysn, 2 ise ondalk iaretinden sonraki maksimum hane saysn belirtir.

-- numeric (18, 3): 987654321.123
-- -10^38 + 1 ile 10^38 - 1 arasnda deer tutabilen ondalk say veri tipidir.
-- Bu rnekte 18 ondalk iareti dahil toplam maksimum hane saysn, 3 ise ondalk iaretinden sonraki maksimum hane saysn belirtir.

-- money: 100.50
-- -922,337,203,685,477.5808 ile +922,337,203,685,477.5807 arasnda deer tutabilen ondalk say veri tipidir.

-- smallmoney: 100.50
-- -214,748.3648 ile +214,748.3647 arasnda deer tutabilen ondalk say veri tipidir.

-- Metinsel veri tipleri: Metinsel veriler iin aadaki maksimum karakter saylar Microsoft SQL Server 2019 iin geerlidir.
-- text: 'Trkiye, ankaya, Ankara'
-- Maksimum 2,147,483,647 karakter metinsel veri tutabilir. Tutulan verinin boyutu girilen karakter saysna gre deiir.

-- varchar(10): 'al Leo'
-- varchar(max) ile maksimum 8000 karakter metinsel veri tutabilir. Tutulan verinin boyutu girilen karakter saysna gre deiir.

-- char(4): '2021'
-- char(max) ile maksimum 8000 karakter metinsel veri tutabilir. Tutulan verinin boyutu tanmlanan karakter says zerinden sabittir.
-- Yl verisi sabit 4 karakter olduu iin char veri tipi kullanlabilir.
-- rnein sadece '1' verisini char(4) veri tipindeki bir stuna eklesek veri stunda '   1' olarak saklanacaktr.

-- ntext: N'Trkiye, ankaya, Ankara'
-- Unicode karakter kmesi kulland iin (Trke karakterler de bu veri kmesine dahildir) 
-- maksimum 1,073,741,823 karakter metinsel veri tutabilir.

-- nvarchar(10): N'al Leo'
-- Unicode karakter kmesi kulland iin nvarchar(max) ile maksimum 4000 karakter metinsel veri tutabilir.

-- nchar: N'2021'
-- Unicode karakter kmesi kulland iin nchar(max) ile maksimum 4000 karakter metinsel veri tutabilir.

-- Dier veri tipleri:
-- datetime: '2021-09-08 18:55.44.135'
-- Ocak 1, 1753 ile	Aralk 31, 9999 arasnda 'yl-ay-gn saat:dakika:saniye.milisaniye' zel formatnda deer tutabilen veri tipidir.

-- smalldatetime: '2021-09-08 18:55.44.135'
-- Ocak 1, 1900 ile	Haziran 6, 2079 arasnda 'yl-ay-gn saat:dakika:saniye.milisaniye' zel formatnda deer tutabilen veri tipidir.

-- date: '2021-09-08'
-- Ocak 1, 1753 ile	Aralk 31, 9999 arasnda 'yl-ay-gn' zel formatnda deer tutabilen veri tipidir.

-- binary: rnein binary(1000) olarak tanmlanr.
-- erisine ikilik say sistemi yapsnda veri alabilir. Tutulan verinin boyutu tanmlanan byte uzunluu zerinden sabittir.
-- rnein imaj verisi, mp3 verisi, Word veya Excel dkman verisi tutulabilir. 
-- binary(max) ile maksimum 8000 byte uzunluunda veri tutabilir.

-- varbinary: rnein varbinary(4000) olarak tanmlanr.
-- erisine binary gibi ikilik say sistemi yapsnda veri alabilir. Tutulan verinin boyutu girilen verinin byte uzunluuna gre deiir.
-- varbinary(max) ile maksimum 8000 byte uzunluunda veri tutabilir.

-- image:
-- Maksimum 2,147,483,647 byte uzunluunda veri tutabilen ve imaj verileri iin kullanlan zel bir varbinary veri tipidir.

-- 1) INSERT: Bir tabloya stunlar zerinden yeni bir satr olarak verileri eklemek iin kullanlr.

-- Bir tabloya kayt ekleme ileminden nce eer tabloda foreign key varsa tablonun foreign key zerinden ilikili olduu 
-- dier tabloya nce veriler eklenir ki kayt ekleme ilemini yaptmz tablo foreign key zerinden dier tabloyla iliki kurabilsin.

use Filmler
go

-- 1. kullanm: stenilen stun adlar values'dan nce parantez iinde belli bir srada yazlr, deerler ise values'dan sonra
-- ayn srayla parantez iinde girilir. Bu rnekte dogumtarihi ve emeklimi stun verileri null girilecektir.
insert into Yonetmen (Adi, Soyadi, DogumTarihi, EmekliMi) values ('James', 'Cameron', '1954-08-16', 0) -- id otomatik olarak verilir: 1

-- 2. kullanm: values'dan nce parantez ile stun adlar yazlmaz, deerler ise values'dan sonra tablonun stunlar srasyla
-- parantez iinde girilir. Bu kullanmda eer null deere izin veren bir stun varsa ve null deer girilmek isteniyorsa
-- parantez iinde aadaki rnekte olduu gibi bu stun iin null veri girilmelidir.
insert into Yonetmen values ('Guy', 'Ritchie', null, 0) -- id otomatik olarak verilir: 2

-- Bu rnekte dogumtarihi ve emeklimi stun verileri null olacaktr.
insert into Yonetmen (Adi, Soyadi) values ('F. Gary', 'Gray') -- id otomatik olarak verilir: 3

insert into Yonetmen values ('Ridley', 'Scott', null, 1) -- rnek iin dzeltilecek, id otomatik olarak verilir: 4
insert into Yonetmen values ('David', 'Fincher', '1962-08-28', 0) -- id otomatik olarak verilir: 5
insert into Yonetmen values ('Hatal Giri Ad', 'Hatal Giri Soyad', null, null) -- rnek iin silinecek, id otomatik olarak verilir: 6
insert into Yonetmen values ('David', 'Lynch', null, 0) -- id otomatik olarak verilir: 7

go

insert into Film values ('Hatal Giri', 'Hata', 1, 1000000) -- rnek iin dzeltilecek, id otomatik olarak verilir: 1
insert into Film (Adi, YonetmenId, Gisesi) values ('Sherlock Holmes', 2, 50000) -- id otomatik olarak verilir: 2
insert into Film (Adi, YonetmenId) values ('Hatal Giri', 1) -- rnek iin silinecek, id otomatik olarak verilir: 3
insert into Film (Adi, YapimYili, YonetmenId, Gisesi) values ('Adalet Peinde', '2009', null, 30000) -- rnek iin dzeltilecek, id otomatik olarak verilir: 4
insert into Film values ('Yaratk', '1979', 4, 1000000) -- id otomatik olarak verilir: 5
insert into Film values ('Yaratk 2', '1986', 1, 700000) -- id otomatik olarak verilir: 6
insert into Film values ('Yaratk 3', '1992', 5, 400000) -- id otomatik olarak verilir: 7

insert into Tur values ('Hatal Giri') -- rnek iin dzeltilecek, id otomatik olarak verilir: 1
insert into Tur values ('Bilim Kurgu') -- id otomatik olarak verilir: 2
insert into Tur values ('Aksiyon') -- id otomatik olarak verilir: 3
insert into Tur values ('Dram') -- id otomatik olarak verilir: 4
insert into Tur values ('Gizem') -- id otomatik olarak verilir: 5
insert into Tur values ('Su') -- id otomatik olarak verilir: 6
insert into Tur values ('Macera') -- id otomatik olarak verilir: 7
insert into Tur values ('Korku') -- id otomatik olarak verilir: 8
insert into Tur values ('Uzay') -- id otomatik olarak verilir: 9

-- Film ve Tur verilerini girdikten sonra Film ve Tur arasndaki many to many ilikiyi salayan FilmTur
-- ara tablosuna film id ve tr id zerinden iliki verilerini girebiliriz.
insert into FilmTur values (1, 1)
insert into FilmTur values (1, 2)
insert into FilmTur values (1, 3)
insert into FilmTur values (2, 1)	
insert into FilmTur values (2, 4)	
insert into FilmTur values (2, 3)	
insert into FilmTur values (2, 6)
insert into FilmTur values (5, 7)
insert into FilmTur values (5, 8)
insert into FilmTur values (5, 2)
insert into FilmTur values (5, 9)
insert into FilmTur values (6, 3)
insert into FilmTur values (6, 8)
insert into FilmTur values (6, 2)
insert into FilmTur values (6, 9)
insert into FilmTur values (7, 1)
insert into FilmTur values (7, 3)
insert into FilmTur values (7, 2)
insert into FilmTur values (7, 9)
insert into FilmTur values (4, 3)
insert into FilmTur values (4, 4)

insert into FilmDetay values (2, 60000, 'Sherlock Holmes ve Dr. Watson''n maceralar.') 
insert into FilmDetay values (5, 200000, 'Yaratk serisinin ilk filmi.') 

-- 2) UPDATE: Bir tablodaki bir veya daha fazla satrn stunlarndaki verilerin belli bir koul kmesine gre veya koul olmadan 
-- gncellenmesi iin kullanlr.

-- Eer update ileminde bir foreign key stun verisi gncellenmek isteniyorsa foreign key zerinden ilikili olan dier tabloda
-- gncellenecek id verisinin bulunup bulunmad kontrol edilmelidir. Eer yoksa hata alnacaktr.

--update Film set yonetmenid = 3 
-- Eer bu ekilde sorgu altrlrsa Film tablosundaki tm yonetmen id'ler 3 olarak gncellenir.

update Film set YonetmenId = 3 where Adi = 'Adalet Peinde' 
-- Eer bu ekilde sorgu altrlrsa Film tablosunda sadece ad Adalet Peinde olan filmin ynetmen id'si 3 olarak gncellenir.

-- WHERE: Sorgu iin koul (art) veya koullar (artlar) belirtmek iin kullanlr. Belirtilen koul veya koullara uyan satrlar etkilenir.
-- Update, delete ve select sorgularnda kullanlr. Birden ok koul iin and (ve) ile or (veya) operatrleri kullanlabilir.
-- Bir koulun deilini almak iin de not operatr kullanlr.
-- Where koulundaki stunlar ile =, !=, >, <, >= ve <= operatrleri kullanlabilir.
-- Select konusunda kullanm daha detayl gsterilecektir.

-- update ile birden ok stun virgl ile ayrlarak gncellenebilir.
update Film set Adi = 'Avatar', YapimYili = '2009', YonetmenId = null where Id = 1 -- id'si 1 olan filmin adn Avatar, yapm yln 2009 ve ynetmen id'sini null olarak gnceller.

update Yonetmen set DogumTarihi = '1937-11-30' where Id = 4 -- id'si 4 olan ynetmenin doum tarihini 30.11.1937 olarak gnceller.

update Tur set Adi = 'Gerilim' where Id = 1 -- id'si 1 olan trn adn Gerilim olarak gnceller.

-- 3) DELETE: Bir tablodaki bir veya daha fazla satrn belli bir koul kmesine gre veya koul olmadan 
-- silinmesi iin kullanlr.
--delete from Film 
-- Eer bu ekilde sorgu altrlrsa Film tablosundaki tm satrlar silinir.

delete from Film where Id = 3
-- Eer bu ekilde sorgu altrlrsa film tablosunda sadece id'si 3 olan satr silinir.

delete from Yonetmen where Adi = 'Hatal Giri Ad' -- ad Hatal Giri Ad olan satr ynetmen tablosundan silinir.

delete from FilmTur where FilmId = 4 -- film id'si 4 olan satrlar film tr tablosundan silinir.